package net.w_horse.excelpojo.converter;

import static org.junit.Assert.assertEquals;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.converter.XMLConverter;

public class XMLConverterTest extends AbstractTest {
	/**
	 * XML`ɂRo[^eXg
	 *
	 * @throws ExcelPOJOException
	 * @throws IOException
	 * @throws ParseException
	 *
	 */
	@Test
	public void testConverter() throws ExcelPOJOException, IOException, ParseException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testConverter.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testConverter");
		XMLConverter targetBean = (XMLConverter) bridge.load("./files/upload/ParserTest.xls", "ϊ");

		assertEquals("ϊ Data01", (new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-05")),targetBean.getDate1());
		assertEquals("ϊ DateStr01", "2010N0806",targetBean.getDateStr1());
		assertEquals("ϊ DateStr02", "2010N0807",targetBean.getDateStr2());

		assertEquals("ϊ boolean01", true, targetBean.isBoolean1());
		assertEquals("ϊ boolean02", false,targetBean.isBoolean2());
		assertEquals("ϊ boolean03", true, targetBean.isBoolean3());
		assertEquals("ϊ boolean04", false,targetBean.isBoolean4());
		assertEquals("ϊ boolean05", true, targetBean.isBoolean5());
		assertEquals("ϊ boolean06", false,targetBean.isBoolean6());
		assertEquals("ϊ boolean07", true, targetBean.isBoolean7());
		assertEquals("ϊ boolean08", false,targetBean.isBoolean8());
		assertEquals("ϊ BooleanInt01", 1,targetBean.getBooleanInt1());
		assertEquals("ϊ BooleanInt02", 0,targetBean.getBooleanInt2());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"ϊ",
				"./files/export/XMLParserTest_ϊ.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ϊ.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ϊ");

			assertEquals("ϊ Data01", "2010-08-05", getCellValue(sheet, 2, 4, CELL_TYPE_STRING));
			assertEquals("ϊ DateStr01", "2010-08-06", getCellValue(sheet, 3, 4, CELL_TYPE_STRING));
			assertEquals("ϊ DateStr02", (new SimpleDateFormat("yyyy-MM-dd").parse("2010-08-07")), getCellValue(sheet, 4, 4, CELL_TYPE_DATE));

			assertEquals("ϊ boolean01", "true", getCellValue(sheet, 5, 4, CELL_TYPE_STRING));
			assertEquals("ϊ boolean02", "false", getCellValue(sheet, 6, 4, CELL_TYPE_STRING));
			assertEquals("ϊ boolean03", "yes",getCellValue(sheet, 7, 4, CELL_TYPE_STRING));
			assertEquals("ϊ boolean04", "no",getCellValue(sheet, 8, 4, CELL_TYPE_STRING));
			assertEquals("ϊ boolean05", "", getCellValue(sheet, 9, 4, CELL_TYPE_STRING));
			assertEquals("ϊ boolean06", "~",getCellValue(sheet, 10, 4, CELL_TYPE_STRING));
			assertEquals("ϊ boolean07", "on", getCellValue(sheet, 11, 4, CELL_TYPE_STRING));
			assertEquals("ϊ boolean08", "off",getCellValue(sheet, 12, 4, CELL_TYPE_STRING));
			assertEquals("ϊ BooleanInt01", true,getCellValue(sheet, 13, 4, CELL_TYPE_BOOLEAN));
			assertEquals("ϊ BooleanInt02", false,getCellValue(sheet, 14, 4, CELL_TYPE_BOOLEAN));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂRo[^eXg<br>
	 * XML̒`@ɂCX^X̊mF<br>
	 *
	 * @throws ExcelPOJOException
	 * @throws IOException
	 * @throws ParseException
	 */
	@Test
	public void testConverterInstanciation() throws ExcelPOJOException, IOException, ParseException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testConverterInstanciation.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testConverterInstanciation");
		XMLConverter targetBean = (XMLConverter) bridge.load("./files/upload/ParserTest.xls", "ϊ");

		assertEquals("ϊ DateStr01", "20100806",targetBean.getDateStr1());
		assertEquals("ϊ DateStr02", "2010N0806",targetBean.getDateStr2());
		assertEquals("ϊ DateStr03", "2010N0806",targetBean.getDateStr3());
		assertEquals("ϊ DateStr04", "2010N0806",targetBean.getDateStr4());
		assertEquals("ϊ DateStr05", "2010N0806",targetBean.getDateStr5());
		assertEquals("ϊ DateStr06", "2010N0806",targetBean.getDateStr6());
		assertEquals("ϊ DateStr07", "2010N0806",targetBean.getDateStr7());

	}

}
